VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_SubArt"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Public Idx As Long
Public SUA_Id As String
Public PRD_Code As String
Public PRD_Name As String
Public PRD_Desc As String
Public IMG_Id As Long
Public Vendor_Id As String
 
Public SUA_Type As Long
Public SUA_Stat As String
Public SUA_MatDesc As String
Public SUA_Mat As Long
Public SUA_Thick  As Double
Public SUA_Bwrt  As Double
Public SUA_PU  As Double
Public SUA_Wght  As Double
Public SUA_PUWgh  As Double

Public UM_Code As String
Public UM_Name As String
Public SUA_Grid As Boolean

Public PSA_NeedM2 As Double
Public PSA_NeedPCS As Double
Public SSA_Formula As String
Public SSA_Value As Double
Public SHL_Cover As Long

Public RowStatus As eDPCRowStatus

Private mo_Tools As DPC_Tools

'Public OfferPrice As New Collection
Public OfferPos As DPC_OfferPos

Public Sub CopyFrom(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim lo_OfferPos As DPC_OfferPos
Dim lo_OfferPosCopy As DPC_OfferPos
  
  Idx = ao_SubArt.Idx
  SUA_Id = ao_SubArt.SUA_Id
  PRD_Code = ao_SubArt.PRD_Code
  PRD_Name = ao_SubArt.PRD_Name
  PRD_Desc = ao_SubArt.PRD_Desc
  IMG_Id = ao_SubArt.IMG_Id
  Vendor_Id = ao_SubArt.Vendor_Id
  
  SUA_Type = ao_SubArt.SUA_Type
  SUA_Stat = ao_SubArt.SUA_Stat
  SUA_MatDesc = ao_SubArt.SUA_MatDesc
  SUA_Mat = ao_SubArt.SUA_Mat
  SUA_Thick = ao_SubArt.SUA_Thick
  SUA_Bwrt = ao_SubArt.SUA_Bwrt
  SUA_PU = ao_SubArt.SUA_PU
  SUA_Wght = ao_SubArt.SUA_Wght
  SUA_PUWgh = ao_SubArt.SUA_PUWgh
  UM_Code = ao_SubArt.UM_Code
  UM_Name = ao_SubArt.UM_Name
  SUA_Grid = ao_SubArt.SUA_Grid
  PSA_NeedM2 = ao_SubArt.PSA_NeedM2
  PSA_NeedPCS = ao_SubArt.PSA_NeedPCS
  SSA_Formula = ao_SubArt.SSA_Formula
  SSA_Value = ao_SubArt.SSA_Value
  SHL_Cover = ao_SubArt.SHL_Cover
  RowStatus = ao_SubArt.RowStatus
  
  Call OfferPos.CopyFrom(ao_SubArt.OfferPos)
  Exit Sub
ErrHandler:
  Call errorHandler("CopyFrom")
End Sub

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo errorHandler

  Set mo_Tools = ao_Tools
  Exit Property
errorHandler:
  Call errorHandler("Tools.Set")
End Property

Public Property Get SUA_TWght() As Double
On Error GoTo ErrHandler

  SUA_TWght = OfferPos.OFD_Qty * SUA_PUWgh
  Exit Property
ErrHandler:
  Call errorHandler("SUA_TWght.Get")
End Property

Public Property Get OFD_QtyASpare() As Double
On Error GoTo ErrHandler

  If PSA_NeedPCS > 0 Then
    OFD_QtyASpare = (OfferPos.OFD_QtyA * SUA_PU * SUA_Bwrt - PSA_NeedPCS) / PSA_NeedPCS
  Else
    OFD_QtyASpare = -1
  End If
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtyASpare.Get")
End Property

Public Property Get OFD_QtySpare() As Double
On Error GoTo ErrHandler

  If PSA_NeedPCS > 0 Then
    OFD_QtySpare = (OfferPos.OFD_Qty * SUA_PU * SUA_Bwrt - PSA_NeedPCS) / PSA_NeedPCS
  Else
    OFD_QtySpare = -1
  End If
  Exit Property
ErrHandler:
  Call errorHandler("OFD_QtySpare.Get")
End Property

Public Function CalculateRequiredQty(ByVal ad_SurfQtyM2 As Double, ByVal ad_SurfQtyPCS As Double, ByVal ad_A0 As Double, ByVal ad_A1 As Double, ByVal ad_A2 As Double) As Boolean
On Error GoTo ErrHandler

Dim ld_QtyPU As Double

  CalculateRequiredQty = False
  PSA_NeedM2 = CalculateRequiredQtyFor1M2(ad_SurfQtyM2, ad_SurfQtyPCS, ad_A0, ad_A1, ad_A2)
  PSA_NeedPCS = mo_Tools.RoundUp(ad_SurfQtyM2 * PSA_NeedM2)
  ld_QtyPU = 0
  If (SUA_Bwrt * SUA_PU) > 0 Then
    ld_QtyPU = mo_Tools.RoundUp(PSA_NeedPCS / (SUA_Bwrt * SUA_PU))
    CalculateRequiredQty = True
  End If
  OfferPos.OFD_PU = SUA_PU
  Call OfferPos.SetQty(DPC_UOM_PU, ld_QtyPU)
  Call OfferPos.SetQtyA(DPC_UOM_PU, ld_QtyPU)
  Exit Function
ErrHandler:
  Call errorHandler("CalculateRequiredQty")
End Function

Private Function CalculateRequiredQtyFor1M2(ByVal QtyM2 As Double, ByVal QtyPCS As Double, ByVal A0 As Double, ByVal A1 As Double, ByVal A2 As Double) As Double
On Error GoTo ErrHandler

  If Trim(SSA_Formula) = "" Then
    CalculateRequiredQtyFor1M2 = SSA_Value
  Else
    CalculateRequiredQtyFor1M2 = 0
    Select Case Trim(SSA_Formula)
    Case "1/A2*2"
      If A2 > 0 Then
        CalculateRequiredQtyFor1M2 = 1 / A2 * 2
      End If
    Case "(ROUND(9.6/A1,0)+1)/(37.5)"
      If A1 > 0 Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / (37.5)
      End If
    Case "1/A2*2/4"
      If A2 > 0 Then
        CalculateRequiredQtyFor1M2 = 1 / A2 * 2 / 4
      End If
    Case "(QtyPCS/2)/QtyM2"
      If QtyM2 > 0 Then
        CalculateRequiredQtyFor1M2 = (QtyPCS / 2) / QtyM2
      End If
    Case "1/(A0*A1)*2"
      If (A0 > 0) And (A1 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A0 * A1) * 2
      End If
    Case "2*QtyPCS/QtyM2"
      If (QtyM2 > 0) Then
        CalculateRequiredQtyFor1M2 = 2 * QtyPCS / QtyM2
      End If
    Case "1/(A0*A2*2)"
      If (A0 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A0 * A2 * 2)
      End If
    Case "1/(A0*A2)"
      If (A0 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A0 * A2)
      End If
    Case "2/(A0*A2)"  'something changed by marian ?
      If (A0 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 2 / (A0 * A2)
      End If
    Case "QtyPCS/QtyM2*2"
      If (QtyM2 > 0) Then
        CalculateRequiredQtyFor1M2 = QtyPCS / QtyM2 * 2
      End If
    Case "(QtyM2/A2*4)/QtyM2"
      If (A2 > 0) And (QtyM2 > 0) Then
        CalculateRequiredQtyFor1M2 = (QtyM2 / A2 * 4) / QtyM2
      End If
    Case "(ROUND(9.6/A1,0)+1)/(10*A2)/3.75*2+(ROUND(9.6/A1,0)+1)/(10*A2)"
      If (A1 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / (10 * A2) / 3.75 * 2 + (Round(9.6 / A1, 0) + 1) / (10 * A2)
      End If
    Case "(ROUND(9.6/A1,0)+1)*2/100"
      If (A1 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) * 2 / 100
      End If
    Case "1/(A2*4)"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A2 * 4)
      End If
    Case "1/A2*6"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / A2 * 6
      End If
    Case "1/(2*A2)^2"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (2 * A2) ^ 2
      End If
    Case "ROUND(10/A1+1,0)*2/100"
      If (A1 > 0) Then
        CalculateRequiredQtyFor1M2 = Round(10 / A1 + 1, 0) * 2 / 100
      End If
    Case "2/A2"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 2 / A2
      End If
    Case "(ROUND(9.6/A1,0)+1)/(10*A0)"
      If (A1 > 0) And (A0 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / (10 * A0)
      End If
    Case "(ROUND(9.6/A1,0)+1)/(10*A2)"
      If (A1 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / (10 * A2)
      End If
    Case "1/(A0*A2)*2"
      If (A0 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A0 * A2) * 2
      End If
    Case "(ROUND(9.6/A1,0)+1)/10"
      If (A1 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / 10
      End If
    Case "ROUND(10/A2+1,0)*2/100"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = Round(10 / A2 + 1, 0) * 2 / 100
      End If
    Case "1/A2"
      If (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / A2
      End If
    Case "1/(A0*A1)"
      If (A0 > 0) And (A1 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A0 * A1)
      End If
    Case "1/A1+1/A2"
      If (A1 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / A1 + 1 / A2
      End If
    Case "1/(A1*A2)/4*2"
      If (A1 > 0) And (A2 > 0) Then
        CalculateRequiredQtyFor1M2 = 1 / (A1 * A2) / 4 * 2
      End If
    Case "(ROUND(9.6/A1,0)+1)/(10*A0)*2"
      If (A1 > 0) And (A0 > 0) Then
        CalculateRequiredQtyFor1M2 = (Round(9.6 / A1, 0) + 1) / (10 * A0) * 2
      End If
    Case "QtyPCS/QtyM2"
      If (QtyM2 > 0) Then
        CalculateRequiredQtyFor1M2 = QtyPCS / QtyM2
      End If
    Case Else
      Err.Raise ArmErr.InvalidArgument, "SSA_Formula", "Unknown SSA_Formula: " & SSA_Formula
    End Select
  End If
  Exit Function
ErrHandler:
  Call errorHandler("CalculateRequiredQtyFor1M2")
End Function

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler

  as_Text = Replace(as_Text, "$SUA_Id$", SUA_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRD_Code$", PRD_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRD_Name$", PRD_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRD_Desc$", PRD_Desc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_PU$", mo_Tools.LongToScreen(SUA_PU), , , vbTextCompare)
  as_Text = Replace(as_Text, "$DOF_Name$", OfferPos.DOF_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_MatDesc$", SUA_MatDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_Thick$", mo_Tools.DblToScreen(SUA_Thick), , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_Bwrt$", mo_Tools.DblToScreen(SUA_Bwrt), , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_Wght$", mo_Tools.DblToScreen(SUA_Wght), , , vbTextCompare)
  as_Text = Replace(as_Text, "$SUA_PUWgh$", mo_Tools.DblToScreen(SUA_PUWgh), , , vbTextCompare)
  as_Text = Replace(as_Text, "$UM_Code$", UM_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$UM_Name$", UM_Name, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call errorHandler("ReplaceValuePlaceholder")
End Function

' Standard error handler
Private Sub errorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

